export interface PersonalInfo {
  firstName: string;
  lastName: string;
  email: string;
  phone: string;
  location: string;
  linkedin?: string;
  portfolio?: string;
}

export interface ProfessionalSummary {
  summary: string;
  visaStatus: string;
  rightToWork: string;
}

export interface WorkExperience {
  id: string;
  jobTitle: string;
  company: string;
  location: string;
  startDate: string;
  endDate: string;
  current: boolean;
  responsibilities: string[];
  achievements: string[];
}

export interface Education {
  id: string;
  degree: string;
  institution: string;
  location: string;
  graduationDate: string;
  grade?: string;
  relevantModules?: string;
}

export interface Certification {
  id: string;
  name: string;
  issuingBody: string;
  dateObtained: string;
  expiryDate?: string;
}

export interface Skill {
  category: string;
  items: string[];
}

export interface CVData {
  personalInfo: PersonalInfo;
  professionalSummary: ProfessionalSummary;
  workExperience: WorkExperience[];
  education: Education[];
  certifications: Certification[];
  skills: Skill[];
  languages?: string[];
  references?: string;
}

export interface TemplateConfig {
  id: string;
  name: string;
  description: string;
  industry: string;
  experienceLevel: 'entry' | 'mid' | 'senior';
  keywords: string[];
  colorScheme: string;
}

export const INDUSTRIES = [
  { value: 'tech', label: 'Technology & IT', icon: 'Laptop' },
  { value: 'healthcare', label: 'Healthcare & Care', icon: 'Heart' },
  { value: 'engineering', label: 'Engineering', icon: 'Settings' },
  { value: 'business', label: 'Business & Finance', icon: 'Briefcase' },
  { value: 'education', label: 'Education', icon: 'GraduationCap' },
] as const;

export const EXPERIENCE_LEVELS = [
  { value: 'entry', label: 'Entry Level (0-2 years)', description: 'Recent graduates and junior professionals' },
  { value: 'mid', label: 'Mid Level (3-7 years)', description: 'Experienced professionals' },
  { value: 'senior', label: 'Senior Level (8+ years)', description: 'Senior professionals and managers' },
] as const;

export const VISA_TYPES = [
  { value: 'skilled-worker', label: 'Skilled Worker Visa', description: 'For skilled professionals with job offers' },
  { value: 'health-care', label: 'Health & Care Worker Visa', description: 'For healthcare professionals' },
  { value: 'global-talent', label: 'Global Talent Visa', description: 'For leaders in academia, research, arts, or digital technology' },
  { value: 'graduate', label: 'Graduate Visa', description: 'For recent UK graduates' },
] as const;

export const JOB_ROLES: Record<string, string[]> = {
  tech: [
    'Software Engineer',
    'Frontend Developer',
    'Backend Developer',
    'Full Stack Developer',
    'Data Analyst',
    'Data Scientist',
    'DevOps Engineer',
    'Product Manager',
    'UX/UI Designer',
    'QA Engineer',
  ],
  healthcare: [
    'Registered Nurse',
    'Care Worker',
    'Senior Care Assistant',
    'Healthcare Assistant',
    'Support Worker',
    'Mental Health Nurse',
    'Staff Nurse',
    'Nursing Assistant',
    'Senior Care Worker',
    'Live-in Carer',
  ],
  engineering: [
    'Mechanical Engineer',
    'Electrical Engineer',
    'Civil Engineer',
    'Project Engineer',
    'Design Engineer',
    'Manufacturing Engineer',
    'Quality Engineer',
    'Site Engineer',
    'Structural Engineer',
    'Maintenance Engineer',
  ],
  business: [
    'Business Analyst',
    'Project Manager',
    'Financial Analyst',
    'Marketing Manager',
    'HR Manager',
    'Operations Manager',
    'Management Consultant',
    'Account Manager',
    'Sales Manager',
    'Risk Analyst',
  ],
  education: [
    'Teacher',
    'Lecturer',
    'Teaching Assistant',
    'Early Years Educator',
    'SEN Teacher',
    'Subject Leader',
    'Curriculum Coordinator',
    'Education Consultant',
  ],
};

export const UK_KEYWORDS: Record<string, string[]> = {
  tech: [
    'Agile methodology',
    'Scrum',
    'JavaScript',
    'TypeScript',
    'React',
    'Node.js',
    'Python',
    'SQL',
    'AWS',
    'Azure',
    'Docker',
    'Kubernetes',
    'CI/CD',
    'Git',
    'REST APIs',
    'Microservices',
    'Test-driven development',
    'Problem-solving',
    'Cross-functional collaboration',
    'Stakeholder management',
  ],
  healthcare: [
    'Patient care',
    'Clinical documentation',
    'Medication administration',
    'Care planning',
    'Safeguarding',
    'Person-centred care',
    'MCA',
    'DoLS',
    'Moving and handling',
    'Infection control',
    'Mental health awareness',
    'Dementia care',
    'Palliative care',
    'Teamwork',
    'Communication skills',
    'Empathy',
    'NMC registration',
    'CQC standards',
    'Risk assessment',
    'Care Quality Commission',
  ],
  engineering: [
    'CAD',
    'AutoCAD',
    'SolidWorks',
    'Project management',
    'Health and safety',
    'Risk assessment',
    'Quality assurance',
    'Lean manufacturing',
    'Six Sigma',
    'Technical drawings',
    'FEA',
    'Prototyping',
    'BS/EN standards',
    'HVAC',
    'Building regulations',
    'Site supervision',
    'Contractor management',
    'Cost estimation',
    'Design review',
    'Commissioning',
  ],
  business: [
    'Business analysis',
    'Requirements gathering',
    'Stakeholder management',
    'Project management',
    'Agile',
    'Waterfall',
    'Data analysis',
    'Financial modelling',
    'Strategic planning',
    'Process improvement',
    'Change management',
    'Risk management',
    'Budget management',
    'Team leadership',
    'Client relationship management',
    'Presentation skills',
    'Report writing',
    'Excel',
    'PowerBI',
    'Tableau',
  ],
  education: [
    'Lesson planning',
    'Curriculum development',
    'Assessment for learning',
    'Differentiation',
    'SEN support',
    'Behaviour management',
    'Safeguarding',
    'Parent communication',
    'Team collaboration',
    'CPD',
    'EYFS',
    'National Curriculum',
    'Ofsted standards',
    'Phonics',
    'STEM education',
    'Inclusive practice',
    'Pastoral care',
    'Educational technology',
    'Marking and feedback',
    'Performance management',
  ],
};

export const SPONSOR_KEYWORDS = [
  'Skilled Worker visa eligible',
  'Certificate of Sponsorship',
  'UK visa sponsorship',
  'Right to work UK',
  'Licensed sponsor employer',
  'RQF Level 3 qualified',
  'English language proficiency',
  'Eligible occupation code',
  'Going rate salary',
  'Shortage occupation list',
];

export const INITIAL_CV_DATA: CVData = {
  personalInfo: {
    firstName: '',
    lastName: '',
    email: '',
    phone: '',
    location: '',
    linkedin: '',
    portfolio: '',
  },
  professionalSummary: {
    summary: '',
    visaStatus: '',
    rightToWork: '',
  },
  workExperience: [],
  education: [],
  certifications: [],
  skills: [],
  languages: [],
  references: 'Available upon request',
};
