import { Card, CardContent } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { Star, Quote } from 'lucide-react';

const testimonials = [
  {
    name: 'James Chen',
    role: 'Software Engineer',
    visaType: 'Skilled Worker Visa',
    company: 'Now working at a London fintech',
    content: 'I applied to over 50 jobs with my old CV and got zero responses. After using this CV builder, I received 5 interview requests within 2 weeks. The ATS optimization really works!',
    rating: 5,
    highlight: '5 interviews in 2 weeks',
  },
  {
    name: 'Maria Santos',
    role: 'Registered Nurse',
    visaType: 'Health & Care Worker Visa',
    company: 'Now working for NHS Trust',
    content: 'The nurse CV template was perfect. It included all the NMC registration details and healthcare keywords that NHS recruiters look for. I got my sponsorship offer within a month.',
    rating: 5,
    highlight: 'NHS sponsorship in 1 month',
  },
  {
    name: 'Ahmed Khan',
    role: 'Data Analyst',
    visaType: 'Skilled Worker Visa',
    company: 'Now at a Big Four consultancy',
    content: 'As an international candidate, I wasnt sure how to present my experience. This builder helped me format my CV to UK standards and highlight the skills sponsors want.',
    rating: 5,
    highlight: 'Big Four offer secured',
  },
  {
    name: 'Priya Patel',
    role: 'Business Analyst',
    visaType: 'Skilled Worker Visa',
    company: 'Now at a UK bank',
    content: 'The visa-specific guidance was invaluable. I knew exactly what to include in my Right to Work statement and how to position my experience for UK employers.',
    rating: 5,
    highlight: 'Banking role secured',
  },
  {
    name: 'Amina Hassan',
    role: 'Senior Care Worker',
    visaType: 'Health & Care Worker Visa',
    company: 'Now at a CQC-rated Outstanding care home',
    content: 'The care worker template had all the safeguarding and MCA keywords. My employer said my CV stood out because it showed I understood UK care standards.',
    rating: 5,
    highlight: 'Outstanding rated employer',
  },
  {
    name: 'Robert Müller',
    role: 'Mechanical Engineer',
    visaType: 'Skilled Worker Visa',
    company: 'Now at an automotive manufacturer',
    content: 'The engineering template helped me present my projects and CAD skills effectively. The format is clean and professional - exactly what UK engineering firms expect.',
    rating: 5,
    highlight: 'Automotive industry role',
  },
];

export function Testimonials() {
  return (
    <section className="py-16 md:py-24">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-3xl mx-auto mb-12">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Success Stories from Our Users
          </h2>
          <p className="text-lg text-muted-foreground">
            Join thousands of international professionals who have secured UK visa sponsorship 
            jobs using our CV builder. Here are some of their stories.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          {testimonials.map((testimonial, idx) => (
            <Card key={idx} className="h-full hover:shadow-lg transition-shadow">
              <CardContent className="pt-6">
                <div className="flex items-start justify-between mb-4">
                  <Quote className="h-8 w-8 text-primary/20" />
                  <Badge variant="secondary" className="text-xs">
                    {testimonial.highlight}
                  </Badge>
                </div>
                
                <div className="flex gap-1 mb-4">
                  {Array.from({ length: testimonial.rating }).map((_, i) => (
                    <Star key={i} className="h-4 w-4 fill-yellow-400 text-yellow-400" />
                  ))}
                </div>

                <p className="text-muted-foreground mb-6 text-sm leading-relaxed">
                  "{testimonial.content}"
                </p>

                <div className="border-t pt-4">
                  <p className="font-semibold">{testimonial.name}</p>
                  <p className="text-sm text-muted-foreground">{testimonial.role}</p>
                  <div className="flex items-center gap-2 mt-2">
                    <Badge variant="outline" className="text-xs">
                      {testimonial.visaType}
                    </Badge>
                  </div>
                  <p className="text-xs text-muted-foreground mt-2">
                    {testimonial.company}
                  </p>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
}
