import { Card, CardContent } from '@/components/ui/card';
import { 
  UserCircle, 
  FileEdit, 
  Sparkles, 
  Download,
  ArrowRight
} from 'lucide-react';

const steps = [
  {
    icon: UserCircle,
    step: '01',
    title: 'Choose Your Template',
    description: 'Select from our collection of ATS-friendly templates designed for your industry and visa type. Whether you are a Software Engineer, Nurse, or Business Analyst, we have a template for you.',
  },
  {
    icon: FileEdit,
    step: '02',
    title: 'Fill in Your Details',
    description: 'Enter your personal information, work experience, education, and skills. Our smart form guides you through each section with helpful tips and examples tailored for UK visa applications.',
  },
  {
    icon: Sparkles,
    step: '03',
    title: 'Optimize with Keywords',
    description: 'Our system suggests industry-specific keywords that UK sponsor employers search for. Include terms like "Skilled Worker visa eligible" and relevant technical skills to improve your visibility.',
  },
  {
    icon: Download,
    step: '04',
    title: 'Download & Apply',
    description: 'Export your CV in PDF or DOCX format. Both versions are ATS-optimized and ready to upload to job portals like Indeed, Reed, and LinkedIn. Start applying to UK sponsor companies today.',
  },
];

export function HowItWorks() {
  return (
    <section className="py-16 md:py-24 bg-muted/50">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-3xl mx-auto mb-16">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Build Your UK Sponsorship CV in 4 Easy Steps
          </h2>
          <p className="text-lg text-muted-foreground">
            Our streamlined process helps you create a professional, ATS-friendly CV 
            in under 30 minutes. No design skills needed.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
          {steps.map((item, idx) => (
            <div key={idx} className="relative">
              <Card className="h-full hover:shadow-lg transition-shadow">
                <CardContent className="pt-6">
                  <div className="flex items-center justify-between mb-4">
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                      <item.icon className="h-6 w-6 text-primary" />
                    </div>
                    <span className="text-4xl font-bold text-primary/20">
                      {item.step}
                    </span>
                  </div>
                  <h3 className="text-xl font-semibold mb-2">{item.title}</h3>
                  <p className="text-muted-foreground text-sm">{item.description}</p>
                </CardContent>
              </Card>
              
              {/* Arrow connector - hidden on mobile and last item */}
              {idx < steps.length - 1 && (
                <div className="hidden lg:block absolute top-1/2 -right-3 transform -translate-y-1/2 z-10">
                  <ArrowRight className="h-6 w-6 text-muted-foreground" />
                </div>
              )}
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
