import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';
import { ArrowRight, CheckCircle, Star, Users, FileCheck, Sparkles } from 'lucide-react';

interface HeroProps {
  onStartBuilding: () => void;
}

export function Hero({ onStartBuilding }: HeroProps) {
  const features = [
    'ATS-friendly templates',
    'UK visa sponsorship keywords',
    'PDF & DOCX export',
    'Recruiter-approved formats',
  ];

  const stats = [
    { value: '50K+', label: 'CVs Created' },
    { value: '95%', label: 'ATS Pass Rate' },
    { value: '4.9★', label: 'User Rating' },
  ];

  return (
    <section className="relative overflow-hidden bg-gradient-to-b from-primary/5 via-background to-background">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-5">
        <div className="absolute inset-0" style={{
          backgroundImage: `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23000000' fill-opacity='1'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`,
        }} />
      </div>

      <div className="container mx-auto px-4 py-16 md:py-24 relative">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Left Column - Content */}
          <div className="space-y-8">
            <div className="space-y-4">
              <Badge variant="secondary" className="px-3 py-1 text-sm font-medium">
                <Sparkles className="h-3.5 w-3.5 mr-1" />
                #1 CV Builder for UK Visa Jobs
              </Badge>
              <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight text-foreground">
                Create an{' '}
                <span className="text-primary">ATS-Friendly CV</span>{' '}
                for UK Visa Sponsorship
              </h1>
              <p className="text-lg md:text-xl text-muted-foreground max-w-xl">
                Build a recruiter-approved CV that passes Applicant Tracking Systems and gets you noticed by UK sponsor employers. Optimised for Skilled Worker and Health & Care visas.
              </p>
            </div>

            <div className="flex flex-wrap gap-3">
              {features.map((feature, idx) => (
                <div key={idx} className="flex items-center gap-2 text-sm text-muted-foreground">
                  <CheckCircle className="h-4 w-4 text-primary" />
                  <span>{feature}</span>
                </div>
              ))}
            </div>

            <div className="flex flex-col sm:flex-row gap-4">
              <Button
                size="lg"
                onClick={onStartBuilding}
                className="gap-2 text-lg px-8"
              >
                Build Your CV Free
                <ArrowRight className="h-5 w-5" />
              </Button>
              <Button
                size="lg"
                variant="outline"
                className="gap-2 text-lg"
              >
                <FileCheck className="h-5 w-5" />
                View Templates
              </Button>
            </div>

            <div className="flex items-center gap-6 pt-4">
              {stats.map((stat, idx) => (
                <div key={idx} className="text-center">
                  <div className="text-2xl font-bold text-foreground">{stat.value}</div>
                  <div className="text-sm text-muted-foreground">{stat.label}</div>
                </div>
              ))}
            </div>
          </div>

          {/* Right Column - Visual */}
          <div className="relative hidden lg:block">
            <div className="relative bg-white rounded-xl shadow-2xl p-6 border border-gray-200 transform rotate-1 hover:rotate-0 transition-transform duration-300">
              {/* CV Preview Mock */}
              <div className="space-y-4">
                <div className="border-b-2 border-gray-800 pb-3">
                  <div className="h-6 bg-gray-800 rounded w-2/3 mb-2"></div>
                  <div className="h-3 bg-gray-400 rounded w-full"></div>
                  <div className="h-3 bg-gray-400 rounded w-3/4 mt-1"></div>
                </div>
                <div>
                  <div className="h-4 bg-gray-700 rounded w-1/3 mb-2"></div>
                  <div className="h-3 bg-gray-300 rounded w-full"></div>
                  <div className="h-3 bg-gray-300 rounded w-full mt-1"></div>
                  <div className="h-3 bg-gray-300 rounded w-2/3 mt-1"></div>
                </div>
                <div>
                  <div className="h-4 bg-gray-700 rounded w-1/4 mb-2"></div>
                  <div className="space-y-2">
                    <div className="flex justify-between">
                      <div className="h-3 bg-gray-400 rounded w-1/3"></div>
                      <div className="h-3 bg-gray-400 rounded w-1/4"></div>
                    </div>
                    <div className="h-3 bg-gray-300 rounded w-full"></div>
                    <div className="h-3 bg-gray-300 rounded w-full"></div>
                  </div>
                </div>
                <div>
                  <div className="h-4 bg-gray-700 rounded w-1/4 mb-2"></div>
                  <div className="grid grid-cols-2 gap-2">
                    <div className="h-3 bg-gray-300 rounded"></div>
                    <div className="h-3 bg-gray-300 rounded"></div>
                    <div className="h-3 bg-gray-300 rounded"></div>
                    <div className="h-3 bg-gray-300 rounded"></div>
                  </div>
                </div>
              </div>

              {/* Floating Badges */}
              <div className="absolute -top-4 -right-4 bg-green-500 text-white px-3 py-1 rounded-full text-sm font-medium shadow-lg flex items-center gap-1">
                <CheckCircle className="h-4 w-4" />
                ATS Optimized
              </div>
              <div className="absolute -bottom-4 -left-4 bg-primary text-primary-foreground px-3 py-1 rounded-full text-sm font-medium shadow-lg flex items-center gap-1">
                <Star className="h-4 w-4" />
                UK Format
              </div>
            </div>

            {/* Trust Indicators */}
            <div className="absolute -bottom-8 left-1/2 transform -translate-x-1/2 bg-white rounded-lg shadow-lg px-4 py-2 flex items-center gap-3">
              <Users className="h-5 w-5 text-primary" />
              <span className="text-sm font-medium">Trusted by 50,000+ job seekers</span>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
