import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { 
  FileCheck, 
  Search, 
  Download, 
  Shield, 
  Zap, 
  Globe,
  Award,
  Clock,
  Users
} from 'lucide-react';

const features = [
  {
    icon: FileCheck,
    title: 'ATS-Optimized Templates',
    description: 'Our CVs are designed to pass Applicant Tracking Systems with clean formatting, proper keyword placement, and no graphics that confuse parsers.',
  },
  {
    icon: Search,
    title: 'UK Visa Keywords',
    description: 'Pre-loaded with industry-specific keywords that UK sponsor employers search for. Includes Skilled Worker and Health & Care visa terminology.',
  },
  {
    icon: Download,
    title: 'PDF & DOCX Export',
    description: 'Download your CV in multiple formats. PDF for applications, DOCX for easy editing. Both formats maintain ATS compatibility.',
  },
  {
    icon: Shield,
    title: 'Recruiter Approved',
    description: 'Templates reviewed by UK recruitment consultants who specialise in visa sponsorship placements. Follows UK CV best practices.',
  },
  {
    icon: Zap,
    title: 'Smart Suggestions',
    description: 'Get real-time suggestions for improving your CV based on your target role and visa type. Never miss important details.',
  },
  {
    icon: Globe,
    title: 'International Friendly',
    description: 'Guidance on presenting international qualifications, converting grades, and explaining overseas experience to UK employers.',
  },
  {
    icon: Award,
    title: 'Role-Specific Examples',
    description: 'Access example CVs for Software Engineers, Nurses, Care Workers, Business Analysts, and more. See what works for your industry.',
  },
  {
    icon: Clock,
    title: 'Quick & Easy',
    description: 'Build a professional CV in under 30 minutes. Our intuitive builder guides you through each section with helpful tips.',
  },
  {
    icon: Users,
    title: 'Success Stories',
    description: 'Join thousands who have secured UK visa sponsorship jobs using our CV builder. Read real success stories and learn from their experience.',
  },
];

export function Features() {
  return (
    <section className="py-16 md:py-24 bg-muted/50">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-3xl mx-auto mb-12">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Everything You Need to Land a UK Sponsorship Job
          </h2>
          <p className="text-lg text-muted-foreground">
            Our CV builder is specifically designed for international professionals seeking UK visa sponsorship. 
            From ATS optimization to visa-specific keywords, we've got you covered.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          {features.map((feature, idx) => (
            <Card key={idx} className="group hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mb-4 group-hover:bg-primary/20 transition-colors">
                  <feature.icon className="h-6 w-6 text-primary" />
                </div>
                <CardTitle className="text-xl">{feature.title}</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">{feature.description}</p>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
}
