import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from '@/components/ui/accordion';
import { Card, CardContent } from '@/components/ui/card';
import { HelpCircle, MessageCircle } from 'lucide-react';
import { Button } from '@/components/ui/button';

const faqs = [
  {
    question: 'What is an ATS-friendly CV and why does it matter?',
    answer: 'An ATS (Applicant Tracking System) is software used by UK employers to scan and filter CVs before they reach human recruiters. An ATS-friendly CV uses clean formatting without tables, columns, or graphics, includes relevant keywords from the job description, and follows a standard structure. Over 90% of UK employers use ATS systems, so optimizing your CV is essential for getting past the initial screening.',
  },
  {
    question: 'Should I mention my visa status on my CV?',
    answer: 'Yes, we recommend including a brief Right to Work statement in your Professional Summary. This transparency helps employers immediately understand your sponsorship needs. Example: "Eligible for Skilled Worker visa sponsorship with valid Certificate of Sponsorship requirements." This shows you understand the process and saves recruiters time.',
  },
  {
    question: 'What is the minimum salary for UK Skilled Worker visa?',
    answer: 'As of 2024, the general minimum salary threshold for Skilled Worker visa is £38,700 per year or the "going rate" for your specific occupation, whichever is higher. However, there are exceptions: Health & Care Worker visas have lower thresholds (from £23,200), new entrants under 26 can qualify with lower salaries, and some occupations on the Immigration Salary List have reduced thresholds.',
  },
  {
    question: 'How long should my UK CV be?',
    answer: 'UK CVs should be maximum 2 pages long. For visa sponsorship applications, conciseness is crucial as recruiters review many applications. Focus on relevant experience from the last 10-15 years and include only information that demonstrates your suitability for the specific role. Use bullet points and avoid long paragraphs.',
  },
  {
    question: 'What is a Certificate of Sponsorship (CoS)?',
    answer: 'A Certificate of Sponsorship (CoS) is an electronic record with a unique reference number that your UK employer provides. It is not a physical certificate but a database entry confirming that your employer is sponsoring you for a specific role. You need this reference number to apply for your Skilled Worker or Health & Care Worker visa.',
  },
  {
    question: 'How do I present international qualifications on my UK CV?',
    answer: 'List your qualifications with their original titles, then add the UK equivalent in brackets if known. For example: "Bachelor of Engineering (equivalent to UK BEng)." Consider getting a Statement of Comparability from UK ENIC (formerly NARIC) to verify your qualifications. Include this information in your Education section.',
  },
  {
    question: 'What keywords should I include for UK visa sponsorship jobs?',
    answer: 'Include visa-specific terms like "Skilled Worker visa eligible," "Certificate of Sponsorship," and "Right to work UK." Also include industry-specific keywords from the job description, technical skills, and soft skills. Our CV builder provides tailored keyword suggestions based on your target role and industry.',
  },
  {
    question: 'Can I use this CV builder for free?',
    answer: 'Yes! Our basic CV builder is completely free to use. You can create, edit, and download your CV in PDF and DOCX formats at no cost. We also offer premium templates and advanced features for users who want extra customization and optimization.',
  },
  {
    question: 'What is the difference between Skilled Worker and Health & Care Worker visas?',
    answer: 'The Health & Care Worker visa is a specific route under the Skilled Worker framework for healthcare professionals. It has lower visa fees, faster processing, and lower salary thresholds (£23,200+ vs £38,700+). To qualify, you must have a job offer from the NHS, an NHS supplier, or a CQC-registered adult social care provider.',
  },
  {
    question: 'How do I find UK companies that sponsor visas?',
    answer: 'You can search the UK governments official Register of Licensed Sponsors, use specialized job boards like UK Visa Jobs, or look for job postings that mention "visa sponsorship" or "Skilled Worker visa." Our CV builder includes tips for targeting sponsor employers and optimising your application for these roles.',
  },
];

export function FAQ() {
  return (
    <section className="py-16 md:py-24 bg-muted/50">
      <div className="container mx-auto px-4">
        <div className="grid lg:grid-cols-3 gap-8">
          {/* Left Column - Header */}
          <div className="lg:col-span-1">
            <div className="sticky top-24">
              <div className="flex items-center gap-2 mb-4">
                <HelpCircle className="h-6 w-6 text-primary" />
                <h2 className="text-3xl font-bold">Frequently Asked Questions</h2>
              </div>
              <p className="text-muted-foreground mb-6">
                Got questions about UK visa sponsorship CVs? We've got answers. 
                If you can't find what you're looking for, feel free to contact us.
              </p>
              <Button variant="outline" className="gap-2">
                <MessageCircle className="h-4 w-4" />
                Contact Support
              </Button>
            </div>
          </div>

          {/* Right Column - Accordion */}
          <div className="lg:col-span-2">
            <Card>
              <CardContent className="pt-6">
                <Accordion type="single" collapsible className="w-full">
                  {faqs.map((faq, idx) => (
                    <AccordionItem key={idx} value={`item-${idx}`}>
                      <AccordionTrigger className="text-left text-base font-medium">
                        {faq.question}
                      </AccordionTrigger>
                      <AccordionContent className="text-muted-foreground">
                        {faq.answer}
                      </AccordionContent>
                    </AccordionItem>
                  ))}
                </Accordion>
              </CardContent>
            </Card>
          </div>
        </div>
      </div>
    </section>
  );
}
