import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { ArrowRight, Sparkles, CheckCircle } from 'lucide-react';

interface CTAProps {
  onStartBuilding: () => void;
}

export function CTA({ onStartBuilding }: CTAProps) {
  const benefits = [
    '100% free to get started',
    'No credit card required',
    'Takes less than 30 minutes',
    'ATS-optimized output',
  ];

  return (
    <section className="py-16 md:py-24">
      <div className="container mx-auto px-4">
        <Card className="bg-primary text-primary-foreground overflow-hidden relative">
          {/* Background Pattern */}
          <div className="absolute inset-0 opacity-10">
            <div className="absolute inset-0" style={{
              backgroundImage: `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='1'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`,
            }} />
          </div>

          <CardContent className="relative py-16 px-8 md:px-16">
            <div className="max-w-3xl mx-auto text-center space-y-6">
              <div className="inline-flex items-center gap-2 bg-white/20 px-4 py-2 rounded-full">
                <Sparkles className="h-4 w-4" />
                <span className="text-sm font-medium">Start Your UK Career Today</span>
              </div>

              <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold">
                Ready to Land Your UK Visa Sponsorship Job?
              </h2>

              <p className="text-lg md:text-xl opacity-90 max-w-2xl mx-auto">
                Join 50,000+ successful job seekers who have created ATS-friendly CVs 
                and secured positions with UK sponsor employers.
              </p>

              <div className="flex flex-wrap justify-center gap-4">
                {benefits.map((benefit, idx) => (
                  <div key={idx} className="flex items-center gap-2 text-sm">
                    <CheckCircle className="h-4 w-4" />
                    <span>{benefit}</span>
                  </div>
                ))}
              </div>

              <div className="pt-4">
                <Button
                  size="lg"
                  variant="secondary"
                  onClick={onStartBuilding}
                  className="gap-2 text-lg px-8"
                >
                  Build Your CV Now
                  <ArrowRight className="h-5 w-5" />
                </Button>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </section>
  );
}
