import type { CVData, TemplateConfig } from '@/types/cv';

export const TEMPLATES: TemplateConfig[] = [
  {
    id: 'software-engineer',
    name: 'Software Engineer CV',
    description: 'Optimized for software engineering roles with UK visa sponsorship. Highlights technical skills, project experience, and agile methodology expertise.',
    industry: 'tech',
    experienceLevel: 'mid',
    keywords: ['JavaScript', 'React', 'Node.js', 'Agile', 'CI/CD', 'Cloud Computing', 'Microservices', 'Problem-solving'],
    colorScheme: 'blue',
  },
  {
    id: 'nurse-healthcare',
    name: 'Nurse & Healthcare CV',
    description: 'Designed for nursing and healthcare professionals applying for Health & Care Worker visa. Emphasises clinical skills, NMC registration, and patient care experience.',
    industry: 'healthcare',
    experienceLevel: 'mid',
    keywords: ['Patient Care', 'NMC Registration', 'Clinical Documentation', 'Safeguarding', 'Person-centred Care', 'Medication Administration', 'Care Planning'],
    colorScheme: 'green',
  },
  {
    id: 'care-worker',
    name: 'Care Worker CV',
    description: 'Tailored for care workers and support workers. Focuses on compassion, practical care skills, and compliance with CQC standards.',
    industry: 'healthcare',
    experienceLevel: 'entry',
    keywords: ['Personal Care', 'Moving and Handling', 'Safeguarding', 'MCA', 'DoLS', 'Dementia Care', 'Communication Skills'],
    colorScheme: 'teal',
  },
  {
    id: 'business-analyst',
    name: 'Business Analyst CV',
    description: 'Structured for business analysis roles. Showcases requirements gathering, stakeholder management, and process improvement skills.',
    industry: 'business',
    experienceLevel: 'mid',
    keywords: ['Business Analysis', 'Requirements Gathering', 'Stakeholder Management', 'Process Improvement', 'Agile', 'Data Analysis', 'SQL'],
    colorScheme: 'purple',
  },
  {
    id: 'data-analyst',
    name: 'Data Analyst CV',
    description: 'Perfect for data analytics professionals. Highlights data manipulation, visualisation, statistical analysis, and business intelligence tools.',
    industry: 'tech',
    experienceLevel: 'mid',
    keywords: ['SQL', 'Python', 'Tableau', 'PowerBI', 'Statistical Analysis', 'Data Visualisation', 'ETL', 'Machine Learning'],
    colorScheme: 'indigo',
  },
  {
    id: 'mechanical-engineer',
    name: 'Mechanical Engineer CV',
    description: 'Engineered for mechanical engineering positions. Features CAD expertise, project management, and manufacturing process knowledge.',
    industry: 'engineering',
    experienceLevel: 'mid',
    keywords: ['CAD', 'SolidWorks', 'Project Management', 'Manufacturing', 'Quality Assurance', 'FEA', 'Lean Manufacturing', 'Health and Safety'],
    colorScheme: 'orange',
  },
  {
    id: 'frontend-developer',
    name: 'Frontend Developer CV',
    description: 'Modern template for frontend developers. Emphasises UI/UX skills, responsive design, and modern JavaScript frameworks.',
    industry: 'tech',
    experienceLevel: 'mid',
    keywords: ['React', 'TypeScript', 'CSS', 'HTML', 'Responsive Design', 'UI/UX', 'Webpack', 'Jest'],
    colorScheme: 'cyan',
  },
  {
    id: 'project-manager',
    name: 'Project Manager CV',
    description: 'Strategic template for project management roles. Highlights leadership, budget management, and delivery track record.',
    industry: 'business',
    experienceLevel: 'senior',
    keywords: ['Project Management', 'Agile', 'Scrum', 'Stakeholder Management', 'Budget Management', 'Risk Management', 'Prince2', 'PMP'],
    colorScheme: 'slate',
  },
];

export const EXAMPLE_CVS: Record<string, CVData> = {
  'software-engineer': {
    personalInfo: {
      firstName: 'James',
      lastName: 'Chen',
      email: 'james.chen.dev@email.com',
      phone: '+44 7700 900123',
      location: 'London, UK',
      linkedin: 'linkedin.com/in/jameschendev',
      portfolio: 'github.com/jameschen',
    },
    professionalSummary: {
      summary: 'Results-driven Software Engineer with 5+ years of experience designing and developing scalable web applications. Proficient in full-stack development with expertise in React, Node.js, and cloud technologies. Proven track record of delivering high-quality code and improving system performance by 40%.',
      visaStatus: 'Skilled Worker Visa',
      rightToWork: 'Eligible for Skilled Worker visa sponsorship. Seeking opportunities with licensed UK sponsors.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Senior Software Engineer',
        company: 'Tech Solutions Ltd',
        location: 'Singapore',
        startDate: '2021-03',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Developed and maintained microservices architecture serving 1M+ daily users',
          'Led a team of 5 developers in Agile sprints, delivering features 20% ahead of schedule',
          'Implemented CI/CD pipelines reducing deployment time by 60%',
          'Mentored junior developers and conducted code reviews',
        ],
        achievements: [
          'Reduced API response time by 45% through query optimisation',
          'Awarded "Engineer of the Year" for outstanding contribution to platform stability',
        ],
      },
      {
        id: '2',
        jobTitle: 'Software Developer',
        company: 'Digital Innovations Pte Ltd',
        location: 'Singapore',
        startDate: '2019-06',
        endDate: '2021-02',
        current: false,
        responsibilities: [
          'Built responsive web applications using React and TypeScript',
          'Collaborated with UX designers to implement user-friendly interfaces',
          'Integrated third-party APIs and payment gateways',
          'Wrote unit and integration tests achieving 85% code coverage',
        ],
        achievements: [
          'Successfully delivered 15+ projects for enterprise clients',
          'Introduced automated testing framework adopted company-wide',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'Bachelor of Science in Computer Science',
        institution: 'National University of Singapore',
        location: 'Singapore',
        graduationDate: '2019-05',
        grade: 'Second Class Honours (Upper Division)',
        relevantModules: 'Software Engineering, Data Structures, Algorithms, Database Systems',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'AWS Certified Solutions Architect',
        issuingBody: 'Amazon Web Services',
        dateObtained: '2022-08',
        expiryDate: '2025-08',
      },
      {
        id: '2',
        name: 'Professional Scrum Master I',
        issuingBody: 'Scrum.org',
        dateObtained: '2021-05',
      },
    ],
    skills: [
      {
        category: 'Programming Languages',
        items: ['JavaScript', 'TypeScript', 'Python', 'Java', 'SQL'],
      },
      {
        category: 'Frameworks & Libraries',
        items: ['React', 'Node.js', 'Express', 'Next.js', 'Redux'],
      },
      {
        category: 'Cloud & DevOps',
        items: ['AWS', 'Docker', 'Kubernetes', 'CI/CD', 'Terraform'],
      },
      {
        category: 'Databases',
        items: ['PostgreSQL', 'MongoDB', 'Redis', 'Elasticsearch'],
      },
    ],
    languages: ['English (Professional Working Proficiency)', 'Mandarin (Native)'],
    references: 'Available upon request',
  },
  'nurse-healthcare': {
    personalInfo: {
      firstName: 'Maria',
      lastName: 'Santos',
      email: 'maria.santos.nurse@email.com',
      phone: '+44 7700 900456',
      location: 'Manchester, UK',
      linkedin: 'linkedin.com/in/mariasantosnurse',
    },
    professionalSummary: {
      summary: 'Compassionate and dedicated Registered Nurse with 6+ years of experience in acute care settings. NMC registered with expertise in medical-surgical nursing, patient assessment, and care planning. Committed to delivering person-centred care and maintaining highest standards of clinical practice.',
      visaStatus: 'Health & Care Worker Visa',
      rightToWork: 'NMC registered nurse eligible for Health & Care Worker visa sponsorship. Seeking NHS or CQC-registered employer.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Staff Nurse - Medical Ward',
        company: 'St. Luke\'s Medical Center',
        location: 'Manila, Philippines',
        startDate: '2019-03',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Provided comprehensive nursing care to 20+ medical patients per shift',
          'Administered medications and monitored patient responses',
          'Developed and implemented individualised care plans',
          'Collaborated with multidisciplinary teams for optimal patient outcomes',
          'Mentored student nurses and new staff members',
        ],
        achievements: [
          'Received "Excellence in Patient Care" award in 2022',
          'Achieved 100% compliance with medication administration protocols',
        ],
      },
      {
        id: '2',
        jobTitle: 'Junior Staff Nurse',
        company: 'Manila General Hospital',
        location: 'Manila, Philippines',
        startDate: '2018-01',
        endDate: '2019-02',
        current: false,
        responsibilities: [
          'Delivered patient care in a busy 40-bed medical-surgical unit',
          'Performed vital signs monitoring and patient assessments',
          'Maintained accurate clinical documentation',
          'Assisted in emergency procedures and code blue responses',
        ],
        achievements: [
          'Completed NMC registration process successfully',
          'Passed IELTS Academic with overall band 7.5',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'Bachelor of Science in Nursing',
        institution: 'University of the Philippines',
        location: 'Manila, Philippines',
        graduationDate: '2017-04',
        grade: 'Cum Laude',
        relevantModules: 'Medical-Surgical Nursing, Pharmacology, Pathophysiology, Nursing Research',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'NMC Registration',
        issuingBody: 'Nursing and Midwifery Council UK',
        dateObtained: '2023-06',
      },
      {
        id: '2',
        name: 'Basic Life Support (BLS)',
        issuingBody: 'American Heart Association',
        dateObtained: '2023-01',
        expiryDate: '2025-01',
      },
      {
        id: '3',
        name: 'IELTS Academic',
        issuingBody: 'British Council',
        dateObtained: '2022-11',
      },
    ],
    skills: [
      {
        category: 'Clinical Skills',
        items: ['Patient Assessment', 'Medication Administration', 'Wound Care', 'IV Therapy', 'Catheterisation'],
      },
      {
        category: 'Care Planning',
        items: ['Care Plan Development', 'Risk Assessment', 'Discharge Planning', 'Patient Education'],
      },
      {
        category: 'Compliance & Safety',
        items: ['NMC Standards', 'Safeguarding', 'Infection Control', 'Manual Handling', 'Clinical Governance'],
      },
    ],
    languages: ['English (IELTS 7.5)', 'Filipino (Native)'],
    references: 'Available upon request',
  },
  'care-worker': {
    personalInfo: {
      firstName: 'Amina',
      lastName: 'Hassan',
      email: 'amina.hassan.care@email.com',
      phone: '+44 7700 900789',
      location: 'Birmingham, UK',
      linkedin: 'linkedin.com/in/aminahassancare',
    },
    professionalSummary: {
      summary: 'Dedicated and compassionate Care Worker with 3+ years of experience providing high-quality personal care to elderly and vulnerable adults. Skilled in dementia care, medication support, and promoting independence. Committed to delivering person-centred care with dignity and respect.',
      visaStatus: 'Health & Care Worker Visa',
      rightToWork: 'Eligible for Health & Care Worker visa sponsorship. Experienced in adult social care with CQC-compliant training.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Senior Care Assistant',
        company: 'Sunrise Care Home',
        location: 'Nairobi, Kenya',
        startDate: '2021-05',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Provided personal care to 15+ residents including bathing, dressing, and feeding',
          'Administered medications and maintained accurate MAR charts',
          'Supported residents with mobility and physical therapy exercises',
          'Documented care plans and reported changes in residents\' conditions',
          'Led shift handovers and supervised junior care staff',
        ],
        achievements: [
          'Recognised as "Employee of the Month" three times',
          'Completed advanced dementia care training',
        ],
      },
      {
        id: '2',
        jobTitle: 'Care Assistant',
        company: 'Golden Years Residential Care',
        location: 'Nairobi, Kenya',
        startDate: '2020-02',
        endDate: '2021-04',
        current: false,
        responsibilities: [
          'Assisted residents with daily living activities',
          'Prepared nutritious meals accommodating dietary requirements',
          'Engaged residents in social and recreational activities',
          'Maintained clean and safe living environments',
        ],
        achievements: [
          'Completed NVQ Level 3 in Health and Social Care',
          'Trained in first aid and emergency response',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'NVQ Level 3 in Health and Social Care',
        institution: 'Nairobi Technical Training Institute',
        location: 'Nairobi, Kenya',
        graduationDate: '2021-03',
      },
      {
        id: '2',
        degree: 'Certificate in Dementia Care',
        institution: 'Alzheimer\'s Kenya',
        location: 'Nairobi, Kenya',
        graduationDate: '2022-08',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'Medication Administration',
        issuingBody: 'Kenya Medical Training College',
        dateObtained: '2021-06',
        expiryDate: '2024-06',
      },
      {
        id: '2',
        name: 'First Aid at Work',
        issuingBody: 'St. John Ambulance Kenya',
        dateObtained: '2022-01',
        expiryDate: '2025-01',
      },
      {
        id: '3',
        name: 'Safeguarding Adults',
        issuingBody: 'Ministry of Health Kenya',
        dateObtained: '2020-06',
      },
    ],
    skills: [
      {
        category: 'Personal Care',
        items: ['Bathing and Dressing', 'Feeding Assistance', 'Toileting Support', 'Pressure Area Care'],
      },
      {
        category: 'Specialist Care',
        items: ['Dementia Care', 'Palliative Care', 'Moving and Handling', 'Medication Support'],
      },
      {
        category: 'Soft Skills',
        items: ['Communication', 'Empathy', 'Patience', 'Teamwork', 'Time Management'],
      },
    ],
    languages: ['English (Professional Working Proficiency)', 'Swahili (Native)'],
    references: 'Available upon request',
  },
  'business-analyst': {
    personalInfo: {
      firstName: 'Priya',
      lastName: 'Patel',
      email: 'priya.patel.ba@email.com',
      phone: '+44 7700 900321',
      location: 'London, UK',
      linkedin: 'linkedin.com/in/priyapatelba',
    },
    professionalSummary: {
      summary: 'Strategic Business Analyst with 5+ years of experience driving process improvements and digital transformation initiatives. Expert in requirements elicitation, stakeholder management, and data-driven decision making. Proven ability to deliver projects that reduce costs by 25% and improve operational efficiency.',
      visaStatus: 'Skilled Worker Visa',
      rightToWork: 'Eligible for Skilled Worker visa sponsorship. Seeking opportunities with licensed UK sponsors in financial services or consulting.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Senior Business Analyst',
        company: 'Global Consulting Partners',
        location: 'Mumbai, India',
        startDate: '2021-02',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Led business analysis for digital transformation projects worth £5M+',
          'Facilitated workshops with C-suite stakeholders to define strategic objectives',
          'Developed business cases resulting in £2M annual cost savings',
          'Managed requirements for agile teams using Jira and Confluence',
          'Created data visualisation dashboards for executive reporting',
        ],
        achievements: [
          'Delivered process automation project saving 2,000+ man-hours annually',
          'Received "Consultant of the Year" award for client satisfaction',
        ],
      },
      {
        id: '2',
        jobTitle: 'Business Analyst',
        company: 'FinTech Solutions India',
        location: 'Mumbai, India',
        startDate: '2019-06',
        endDate: '2021-01',
        current: false,
        responsibilities: [
          'Gathered and documented business requirements for banking applications',
          'Conducted gap analysis and process mapping for legacy system migrations',
          'Collaborated with development teams to ensure accurate implementation',
          'Performed UAT and trained end-users on new systems',
        ],
        achievements: [
          'Successfully delivered 8 major projects on time and within budget',
          'Implemented new reporting system improving data accuracy by 35%',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'Master of Business Administration (MBA)',
        institution: 'Indian Institute of Management',
        location: 'Ahmedabad, India',
        graduationDate: '2019-03',
        grade: 'Distinction',
        relevantModules: 'Business Strategy, Data Analytics, Project Management, Operations',
      },
      {
        id: '2',
        degree: 'Bachelor of Commerce',
        institution: 'University of Mumbai',
        location: 'Mumbai, India',
        graduationDate: '2017-05',
        grade: 'First Class',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'Certified Business Analysis Professional (CBAP)',
        issuingBody: 'IIBA',
        dateObtained: '2022-09',
      },
      {
        id: '2',
        name: 'Agile Certified Practitioner (PMI-ACP)',
        issuingBody: 'Project Management Institute',
        dateObtained: '2021-11',
      },
      {
        id: '3',
        name: 'IELTS Academic',
        issuingBody: 'British Council',
        dateObtained: '2023-02',
      },
    ],
    skills: [
      {
        category: 'Business Analysis',
        items: ['Requirements Elicitation', 'Process Mapping', 'Gap Analysis', 'Business Case Development', 'Stakeholder Management'],
      },
      {
        category: 'Tools & Technologies',
        items: ['Jira', 'Confluence', 'Microsoft Visio', 'PowerBI', 'Tableau', 'SQL', 'Excel'],
      },
      {
        category: 'Methodologies',
        items: ['Agile', 'Scrum', 'Waterfall', 'Lean Six Sigma', 'BPMN'],
      },
    ],
    languages: ['English (IELTS 8.0)', 'Hindi (Fluent)', 'Gujarati (Native)'],
    references: 'Available upon request',
  },
  'data-analyst': {
    personalInfo: {
      firstName: 'Ahmed',
      lastName: 'Khan',
      email: 'ahmed.khan.data@email.com',
      phone: '+44 7700 900654',
      location: 'Leeds, UK',
      linkedin: 'linkedin.com/in/ahmedkhandata',
      portfolio: 'ahmedkhan.github.io',
    },
    professionalSummary: {
      summary: 'Data Analyst with 4+ years of experience transforming complex datasets into actionable business insights. Proficient in SQL, Python, and data visualisation tools. Track record of building predictive models that increased revenue by 15% and reduced customer churn by 20%.',
      visaStatus: 'Skilled Worker Visa',
      rightToWork: 'Eligible for Skilled Worker visa sponsorship. Seeking data analytics roles with licensed UK employers.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Data Analyst',
        company: 'E-Commerce Giants Ltd',
        location: 'Dubai, UAE',
        startDate: '2020-08',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Analysed customer behaviour data to identify trends and opportunities',
          'Built automated dashboards using Tableau and PowerBI for executive reporting',
          'Developed SQL queries and Python scripts for data extraction and transformation',
          'Collaborated with marketing team to optimise campaign performance',
          'Created predictive models for sales forecasting and inventory management',
        ],
        achievements: [
          'Built customer segmentation model increasing marketing ROI by 30%',
          'Developed real-time dashboard reducing reporting time by 80%',
        ],
      },
      {
        id: '2',
        jobTitle: 'Junior Data Analyst',
        company: 'Retail Analytics Co',
        location: 'Dubai, UAE',
        startDate: '2019-03',
        endDate: '2020-07',
        current: false,
        responsibilities: [
          'Performed data cleaning and preprocessing for analysis projects',
          'Created visualisations and reports for business stakeholders',
          'Assisted in A/B testing and statistical analysis',
          'Maintained data quality and integrity across databases',
        ],
        achievements: [
          'Identified pricing optimisation opportunity worth £500K annually',
          'Automated monthly reporting saving 40 hours per month',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'Master of Science in Data Science',
        institution: 'University of Dubai',
        location: 'Dubai, UAE',
        graduationDate: '2019-01',
        grade: 'Distinction',
        relevantModules: 'Machine Learning, Statistical Analysis, Big Data, Data Visualisation',
      },
      {
        id: '2',
        degree: 'Bachelor of Science in Statistics',
        institution: 'Lahore University',
        location: 'Lahore, Pakistan',
        graduationDate: '2017-06',
        grade: 'First Class',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'Google Data Analytics Certificate',
        issuingBody: 'Google',
        dateObtained: '2021-04',
      },
      {
        id: '2',
        name: 'Tableau Desktop Specialist',
        issuingBody: 'Tableau',
        dateObtained: '2022-03',
      },
      {
        id: '3',
        name: 'AWS Certified Data Analytics',
        issuingBody: 'Amazon Web Services',
        dateObtained: '2023-01',
        expiryDate: '2026-01',
      },
    ],
    skills: [
      {
        category: 'Programming',
        items: ['Python', 'R', 'SQL', 'Scala'],
      },
      {
        category: 'Data Tools',
        items: ['Tableau', 'PowerBI', 'Looker', 'Apache Spark', 'Hadoop'],
      },
      {
        category: 'Analytics',
        items: ['Statistical Analysis', 'Machine Learning', 'A/B Testing', 'ETL', 'Data Mining'],
      },
      {
        category: 'Cloud Platforms',
        items: ['AWS', 'Google Cloud', 'Azure'],
      },
    ],
    languages: ['English (Professional Working Proficiency)', 'Urdu (Native)', 'Arabic (Conversational)'],
    references: 'Available upon request',
  },
  'mechanical-engineer': {
    personalInfo: {
      firstName: 'Robert',
      lastName: 'Müller',
      email: 'robert.mueller.eng@email.com',
      phone: '+44 7700 900987',
      location: 'Sheffield, UK',
      linkedin: 'linkedin.com/in/robertmuellereng',
    },
    professionalSummary: {
      summary: 'Chartered Mechanical Engineer with 7+ years of experience in design, manufacturing, and project management. Expert in CAD/CAM, FEA analysis, and lean manufacturing principles. Proven track record of delivering complex engineering projects on time and within budget.',
      visaStatus: 'Skilled Worker Visa',
      rightToWork: 'Eligible for Skilled Worker visa sponsorship. Chartered Engineer seeking opportunities with UK manufacturing or engineering firms.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Senior Mechanical Engineer',
        company: 'Precision Engineering GmbH',
        location: 'Stuttgart, Germany',
        startDate: '2019-05',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Led design and development of automotive components for major OEMs',
          'Managed engineering projects from concept to production worth €2M+',
          'Performed FEA simulations and validated designs against industry standards',
          'Supervised a team of 4 engineers and 3 technicians',
          'Implemented lean manufacturing processes reducing waste by 25%',
        ],
        achievements: [
          'Designed award-winning lightweight component reducing weight by 30%',
          'Achieved ISO 9001 and IATF 16949 certification for department',
        ],
      },
      {
        id: '2',
        jobTitle: 'Mechanical Design Engineer',
        company: 'Industrial Systems AG',
        location: 'Munich, Germany',
        startDate: '2017-02',
        endDate: '2019-04',
        current: false,
        responsibilities: [
          'Created 3D CAD models and 2D drawings using SolidWorks and AutoCAD',
          'Conducted design reviews and DFMEA analysis',
          'Collaborated with manufacturing team on design for manufacturability',
          'Prepared technical documentation and BOMs',
        ],
        achievements: [
          'Reduced design cycle time by 20% through standardisation',
          'Successfully launched 5 new products to market',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'Master of Engineering in Mechanical Engineering',
        institution: 'Technical University of Munich',
        location: 'Munich, Germany',
        graduationDate: '2017-01',
        grade: 'Distinction',
        relevantModules: 'Advanced CAD, FEA, Thermodynamics, Project Management',
      },
      {
        id: '2',
        degree: 'Bachelor of Engineering',
        institution: 'RWTH Aachen University',
        location: 'Aachen, Germany',
        graduationDate: '2015-07',
        grade: 'Upper Second Class',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'Chartered Engineer (CEng)',
        issuingBody: 'Engineering Council UK',
        dateObtained: '2022-09',
      },
      {
        id: '2',
        name: 'Certified SolidWorks Professional',
        issuingBody: 'Dassault Systèmes',
        dateObtained: '2020-04',
      },
      {
        id: '3',
        name: 'Six Sigma Black Belt',
        issuingBody: 'ASQ',
        dateObtained: '2021-08',
      },
    ],
    skills: [
      {
        category: 'CAD/CAM',
        items: ['SolidWorks', 'AutoCAD', 'CATIA', 'Siemens NX', 'ANSYS'],
      },
      {
        category: 'Engineering',
        items: ['FEA', 'CFD', 'DFMEA', 'GD&T', 'Tolerance Analysis', 'Material Selection'],
      },
      {
        category: 'Project Management',
        items: ['Project Planning', 'Budget Management', 'Risk Assessment', 'Agile', 'Prince2'],
      },
      {
        category: 'Manufacturing',
        items: ['Lean Manufacturing', 'Six Sigma', 'CNC Programming', 'Quality Control', 'ISO 9001'],
      },
    ],
    languages: ['English (Professional Working Proficiency)', 'German (Native)'],
    references: 'Available upon request',
  },
  'frontend-developer': {
    personalInfo: {
      firstName: 'Sofia',
      lastName: 'Rodriguez',
      email: 'sofia.rodriguez.dev@email.com',
      phone: '+44 7700 900147',
      location: 'Bristol, UK',
      linkedin: 'linkedin.com/in/sofiarodriguezdev',
      portfolio: 'sofia-dev.com',
    },
    professionalSummary: {
      summary: 'Creative Frontend Developer with 4+ years of experience building responsive, user-centric web applications. Expert in modern JavaScript frameworks, accessibility standards, and performance optimisation. Passionate about creating inclusive digital experiences that delight users.',
      visaStatus: 'Skilled Worker Visa',
      rightToWork: 'Eligible for Skilled Worker visa sponsorship. Seeking frontend roles with UK tech companies and digital agencies.',
    },
    workExperience: [
      {
        id: '1',
        jobTitle: 'Frontend Developer',
        company: 'Digital Agency Barcelona',
        location: 'Barcelona, Spain',
        startDate: '2020-06',
        endDate: '2024-01',
        current: false,
        responsibilities: [
          'Developed responsive web applications for 30+ clients across industries',
          'Implemented accessibility standards (WCAG 2.1 AA) across all projects',
          'Optimised website performance achieving 90+ Lighthouse scores',
          'Collaborated with designers to implement pixel-perfect UI components',
          'Mentored junior developers and conducted code reviews',
        ],
        achievements: [
          'Reduced page load time by 60% through code splitting and lazy loading',
          'Built design system adopted across 15+ projects',
        ],
      },
      {
        id: '2',
        jobTitle: 'Junior Web Developer',
        company: 'StartupHub Madrid',
        location: 'Madrid, Spain',
        startDate: '2019-01',
        endDate: '2020-05',
        current: false,
        responsibilities: [
          'Built landing pages and marketing websites using HTML, CSS, and JavaScript',
          'Integrated CMS platforms (WordPress, Contentful) for client websites',
          'Fixed bugs and implemented new features in existing applications',
          'Participated in agile ceremonies and sprint planning',
        ],
        achievements: [
          'Launched 20+ client websites on time and within budget',
          'Learned React and TypeScript, contributing to major project rewrite',
        ],
      },
    ],
    education: [
      {
        id: '1',
        degree: 'Bachelor of Science in Computer Science',
        institution: 'Universidad Politécnica de Madrid',
        location: 'Madrid, Spain',
        graduationDate: '2018-06',
        grade: 'First Class Honours',
        relevantModules: 'Web Development, Human-Computer Interaction, Software Engineering',
      },
    ],
    certifications: [
      {
        id: '1',
        name: 'AWS Certified Developer',
        issuingBody: 'Amazon Web Services',
        dateObtained: '2022-07',
        expiryDate: '2025-07',
      },
      {
        id: '2',
        name: 'Google UX Design Certificate',
        issuingBody: 'Google',
        dateObtained: '2021-09',
      },
    ],
    skills: [
      {
        category: 'Frontend',
        items: ['React', 'TypeScript', 'Next.js', 'Vue.js', 'HTML5', 'CSS3', 'SASS'],
      },
      {
        category: 'Tools & Workflow',
        items: ['Webpack', 'Vite', 'Git', 'Jest', 'Cypress', 'Storybook', 'Figma'],
      },
      {
        category: 'Performance & Accessibility',
        items: ['WCAG 2.1', 'Lighthouse', 'Core Web Vitals', 'Responsive Design', 'Cross-browser Testing'],
      },
    ],
    languages: ['English (Professional Working Proficiency)', 'Spanish (Native)', 'Catalan (Fluent)'],
    references: 'Available upon request',
  },
};

export const getTemplateById = (id: string): TemplateConfig | undefined => {
  return TEMPLATES.find(t => t.id === id);
};

export const getExampleCV = (id: string): CVData | undefined => {
  return EXAMPLE_CVS[id];
};

export const getTemplatesByIndustry = (industry: string): TemplateConfig[] => {
  return TEMPLATES.filter(t => t.industry === industry);
};
